Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      deq_lcr.sql - Dequeues a message from MGWUSER.MGW_LCR_DEST.
Rem
Rem    DESCRIPTION
Rem      This script dequeues a message from queue MGWUSER.MGW_LCR_DEST.
Rem      If no message is available or the message is not a LCR, an 
Rem      exception is raised.
Rem

set serveroutput on;

declare
  dequeue_options        dbms_aq.dequeue_options_t;
  message_properties     dbms_aq.message_properties_t;
  payload                sys.anydata;
  msgid                  RAW(16);
  lcrInXml               XMLType;
begin
  dequeue_options.navigation := 1;
  dequeue_options.wait := dbms_aq.NO_WAIT;

  dbms_aq.dequeue(queue_name         => 'mgwuser.mgw_lcr_dest',
                  dequeue_options    => dequeue_options,
                  message_properties => message_properties,
                  payload            => payload,
                  msgid              => msgid);

  -- convert the message to a XMLType object
  lcrInXml := dbms_mgwmsg.lcr_to_xml(payload);

  -- check the LCR type
  if (lcrInXml.existsNode('DDL_LCR') = 1) then 
      dbms_output.put_line('Received a DDL LCR from ' ||
                           'mgwuser.mgw_lcr_dest');
  elsif (lcrInXml.existsNode('ROW_LCR') = 1) then
      dbms_output.put_line('Received a ROW LCR from ' ||
                           'mgwuser.mgw_lcr_dest');
  else
      raise_application_error(-20000, 'Unexpected message');
  end if;

  commit;
end dequeue;
/
